CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    
	IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_vd_it_lote' and column_name='cd_lote') THEN 
		ALTER TABLE pdv_vd_it_lote
		ALTER COLUMN cd_lote TYPE numeric(10);
	END IF; 

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 


DROP VIEW IF EXISTS v_cupomfiscal_item;

SELECT addColumn();

DROP FUNCTION addColumn();


CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'v_cupomfiscal_item') THEN 
		DROP VIEW v_cupomfiscal_item;
        RAISE NOTICE 'v_cupomfiscal_item Dropada.';
    END IF;

	CREATE VIEW v_cupomfiscal_item AS
	 SELECT vd.cd_emp,
		vd.cd_filial,
		vd.dt_vd,
		COALESCE(vd.dt_cad, vd.dt_vd) AS dt_cad,
		COALESCE(vd.dt_cad, vd.hr_vd) AS hr_vd,
		vd.cd_cx,
		vd.cd_vd,
		vd.nr_ecf,
		vd.st_vd,
		it.cd_it,
		it.cd_prod,
		est_orc_glb_medico.cd_medico_rec,
		NULL::character varying AS ds_prod,
		NULL::character varying AS cd_barra,
		it.qt_it,
		it.vlr_it,
		it.vlr_liq_it AS tot_it,
		it.st_it,
		it.tipo_desconto,
		COALESCE(it.tx_desc, (0)::numeric) AS tx_desc,
		COALESCE(it.vlr_desc_verba, (0)::numeric) AS vlr_desc_verba,
		COALESCE(it.vlr_desc_tot_rat, (0)::numeric) AS vlr_desc_rateio,
		it.cd_trib_fc,
		it.tx_icms_it,
		it.tx_red_it,
		it.cd_vend,
		NULL::character varying AS nm_vend,
		it.cd_vend_verba,
		NULL::character varying AS nm_vend_verba,
		it.cd_usu_cancel,
		NULL::character varying AS nm_usu_cancel,
		it.qtde_ponto_fidel AS qt_pontos_fidel,
		it.cd_grp_comis_pdv AS cd_grupo_comissao,
		(it.st_it <> (1)::numeric) AS is_cancelado,
		COALESCE(lote.cd_lote, (0)::numeric) AS cd_lote,
		0 AS numero_lote,
		COALESCE(lote.qtde_lote, (0)::numeric) AS qtde_prod_lote,
		(COALESCE(it.reg_alterado, 0) = 1) AS registroalteradoitem,
		COALESCE(it.tipo_imposto, (0)::numeric) AS tipo_imposto,
		it.vlr_imposto_it AS valor_ibpt_item,
		it.tx_imposto_it AS percentual_ibpt_item,
		it.nr_protocolo_manipulado,
		COALESCE(vd.flag_consolidado, 0) AS flag_consolidado,
		it.origem_produto,
		COALESCE(it.perc_fcp, 0.0) AS perc_fcp,
		COALESCE(it.perc_fecop_st, 0.0) AS perc_fecop_st,
		COALESCE(it.perc_fecop_ret, 0.0) AS perc_fecop_ret,
		COALESCE(it.perc_icms, 0.0) AS perc_icms,
		COALESCE(it.perc_icms_subst, 0.0) AS perc_icms_subst,
		COALESCE(it.perc_red_base_calc, 0.0) AS perc_red_base_calc,
		Coalesce(it.motivo_desonerado_icms,0) as motivo_desonerado_icms,
		Coalesce(it.icms_desonerado, 0) as icms_desonerado,
		Coalesce(it.vlr_icms_desonerado_it, 0.0) as vlr_icms_desonerado_it,
		vd.regime_tributario,
		COALESCE(it.cfop, 0) as cfop,
		COALESCE(it.vlr_base_calc, 0.00) as vlr_base_calc,
		COALESCE(it.vlr_icms, 0.00) as vlr_icms,
		COALESCE(it.vlr_base_subst, 0.00) as vlr_base_subst,
		COALESCE(it.vlr_isento, 0.00) as vlr_isento,
		COALESCE(it.vlr_outras,  0.00) as vlr_outras,
		COALESCE(it.vlr_icms_subst,  0.00) as vlr_icms_subst,
		COALESCE(it.vlr_fecop,  0.00) as vlr_fecop,
		COALESCE(it.vlr_fecop_st,  0.00) as vlr_fecop_st,
		COALESCE(it.vlr_fecop_ret,  0.00)  as vlr_fecop_ret
	   FROM (((pdv_vd vd
		 JOIN pdv_vd_it it ON ((((it.cd_emp = vd.cd_emp) AND (it.cd_filial = vd.cd_filial)) AND (it.cd_vd = vd.cd_vd))))
		 LEFT JOIN pdv_vd_it_lote lote ON (((((it.cd_emp = lote.cd_emp) AND (it.cd_filial = lote.cd_filial)) AND (vd.cd_vd = lote.cd_vd)) AND (it.cd_it = lote.cd_it))))
		 LEFT JOIN est_orc_glb_medico ON (((((vd.cd_emp = (est_orc_glb_medico.cd_emp)::numeric) AND
		 (vd.cd_filial = (est_orc_glb_medico.cd_filial)::numeric)) AND (vd.nr_orc = (est_orc_glb_medico.nr_orc)::numeric)) AND
		 (it.cd_prod = (est_orc_glb_medico.cd_prod)::numeric)))
		 AND (it.cd_it = (est_orc_glb_medico.cd_it)::numeric))
	  WHERE ((vd.st_vd > ((-1))::numeric) AND (vd.nr_ecf > (0)::numeric));
	
	RAISE NOTICE 'v_cupomfiscal_item Recriada.';
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();